onEvent('block.registry', event => {
	const Block = (
		// 这里的每一项对应着一定的顺序例如
		Name, // 命名ID
		Material,  // 材质
		Hardness,  // 硬度
		Resistance,  // 爆炸抗性
		Tool, // 所需工具类型
		Grade,  // 工具等级(如木,石,铁等)
		RequiresTool  // 是否需要工具挖掘(填true或false)
	) => {
		event.create(Name)
			.material(Material)
			.hardness(Hardness)
			.resistance(Resistance)
			.tagBlock(Tool)
			.tagBlock(Grade)
			.requiresTool(RequiresTool)
	}

	/*
	注意!注册新的方块, 一定需要按照上面的顺序来进行注册!
	顺序: ID, 材质, 硬度, 爆炸抗性, 工具类型, 工具等级, 是否需要工具, 示例:
	Block('test_block', 'stone', 5, 5, 'minecraft:mineable/shovel', 'minecraft:needs_wooder_tool', false)
	千万不要乱了!注意!不用写前面的那一串东西了!直接写要填入的参数等信息!
	**/

	// 神秘砂砾
	Block('mystery_gravel', 'sand', 5, 5, 'minecraft:mineable/shovel', 'minecraft:needs_wooder_tool', false)
	// 重锻黑曜石
	Block('recoin_obsidian', 'stone', 350, 200, 'minecraft:mineable/pickaxe', 'forge:needs_netherite_tool', true)
	// 桥接方块
	Block('trim', 'plank', 5, 5, 'minecraft:mineable/axe', 'minecraft:neesd_wooder_tool', false)
	// 光耀合金块
	Block('shine_alloy_block', 'metal', 5, 5, 'minecraft:mineable/pickaxe', 'minecraft:needs_diamond_tool', true)
	// 铸铁块
	Block('cast_iron_block', 'metal', 3, 3, 'minecraft:mineable/pickaxe', 'minecraft:needs_iron_tool', true)
	// 泡沫铝块
	Block('foamed_aluminium_block', 'metal', 2, 2, 'minecraft:mineable/pickaxe', 'minecraft:needs_iron_tool', true)
	// 神匠块
	Block('hephaestus_block', 'metal', 5, 5, 'minecraft:mineable/pickaxe', 'forge:needs_netherite_tool', true)
	// 记忆合金块
	Block('memory_alloy_block', 'metal', 2, 2, 'minecraft:mineable/pickaxe', 'minecraft:needs_iron_tool', true)
	// 乌鲁铜块
	Block('uru_copper_block', 'metal', 2, 2, 'minecraft:mineable/pickaxe', 'minecraft:needs_diamond_tool', true)
	//假无尽
	Block('fake_infinity_block','metal', 350, 200, 'minecraft:mineable/pickaxe', 'forge:needs_netherite_tool', true)
	//铱矿石
	Block('iridium_ore','stone', 250, 200, 'minecraft:mineable/pickaxe', 'forge:needs_netherite_tool', true)
	//五彩碎片矿石
	Block('prismatic_shard_ore','stone', 250, 200, 'minecraft:mineable/pickaxe', 'forge:needs_overworld_gobber_tool', true)
})